/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CompositeDomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.DefaultDependencySet;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultPublishArtifactSet;
import org.gradle.api.internal.artifacts.ExcludeRuleNotationParser;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.DetachedConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.configurations.TasksFromDependentProjects;
import org.gradle.api.internal.artifacts.configurations.TasksFromProjectDependencies;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.listener.ListenerManager;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.util.CollectionUtils;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.WrapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfiguration
extends AbstractFileCollection
implements ConfigurationInternal {
    private final String path;
    private final String name;
    private Configuration.Visibility visibility = Configuration.Visibility.PUBLIC;
    private boolean transitive = true;
    private Set<Configuration> extendsFrom = new LinkedHashSet<Configuration>();
    private String description;
    private ConfigurationsProvider configurationsProvider;
    private final ConfigurationResolver resolver;
    private final ListenerManager listenerManager;
    private final DependencyMetaDataProvider metaDataProvider;
    private final DefaultDependencySet dependencies;
    private final CompositeDomainObjectSet<Dependency> inheritedDependencies;
    private final DefaultDependencySet allDependencies;
    private final DefaultPublishArtifactSet artifacts;
    private final CompositeDomainObjectSet<PublishArtifact> inheritedArtifacts;
    private final DefaultPublishArtifactSet allArtifacts;
    private final ConfigurationResolvableDependencies resolvableDependencies = new ConfigurationResolvableDependencies();
    private final ListenerBroadcast<DependencyResolutionListener> resolutionListenerBroadcast;
    private Set<ExcludeRule> excludeRules = new LinkedHashSet<ExcludeRule>();
    private final Object lock = new Object();
    private Configuration.State state = Configuration.State.UNRESOLVED;
    private ResolverResults cachedResolverResults;
    private final ResolutionStrategyInternal resolutionStrategy;

    public DefaultConfiguration(String path, String name, ConfigurationsProvider configurationsProvider, ConfigurationResolver resolver, ListenerManager listenerManager, DependencyMetaDataProvider metaDataProvider, ResolutionStrategyInternal resolutionStrategy) {
        this.path = path;
        this.name = name;
        this.configurationsProvider = configurationsProvider;
        this.resolver = resolver;
        this.listenerManager = listenerManager;
        this.metaDataProvider = metaDataProvider;
        this.resolutionStrategy = resolutionStrategy;
        this.resolutionListenerBroadcast = listenerManager.createAnonymousBroadcaster(DependencyResolutionListener.class);
        DefaultDomainObjectSet ownDependencies = new DefaultDomainObjectSet(Dependency.class);
        ownDependencies.beforeChange((Runnable)new VetoContainerChangeAction());
        this.dependencies = new DefaultDependencySet(String.format("%s dependencies", this.getDisplayName()), (DomainObjectSet)ownDependencies);
        this.inheritedDependencies = new CompositeDomainObjectSet(Dependency.class, new DomainObjectCollection[]{ownDependencies});
        this.allDependencies = new DefaultDependencySet(String.format("%s all dependencies", this.getDisplayName()), this.inheritedDependencies);
        DefaultDomainObjectSet ownArtifacts = new DefaultDomainObjectSet(PublishArtifact.class);
        ownArtifacts.beforeChange((Runnable)new VetoContainerChangeAction());
        this.artifacts = new DefaultPublishArtifactSet(String.format("%s artifacts", this.getDisplayName()), (DomainObjectSet)ownArtifacts);
        this.inheritedArtifacts = new CompositeDomainObjectSet(PublishArtifact.class, new DomainObjectCollection[]{ownArtifacts});
        this.allArtifacts = new DefaultPublishArtifactSet(String.format("%s all artifacts", this.getDisplayName()), this.inheritedArtifacts);
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration.State getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state;
        }
    }

    public ModuleInternal getModule() {
        return this.metaDataProvider.getModule();
    }

    public boolean isVisible() {
        return this.visibility == Configuration.Visibility.PUBLIC;
    }

    public Configuration setVisible(boolean visible) {
        this.throwExceptionIfNotInUnresolvedState();
        this.visibility = visible ? Configuration.Visibility.PUBLIC : Configuration.Visibility.PRIVATE;
        return this;
    }

    public Set<Configuration> getExtendsFrom() {
        return Collections.unmodifiableSet(this.extendsFrom);
    }

    public Configuration setExtendsFrom(Iterable<Configuration> extendsFrom) {
        this.throwExceptionIfNotInUnresolvedState();
        for (Configuration configuration : this.extendsFrom) {
            this.inheritedArtifacts.removeCollection((DomainObjectCollection)configuration.getAllArtifacts());
            this.inheritedDependencies.removeCollection((DomainObjectCollection)configuration.getAllDependencies());
        }
        this.extendsFrom = new HashSet<Configuration>();
        for (Configuration configuration : extendsFrom) {
            this.extendsFrom(configuration);
        }
        return this;
    }

    public Configuration extendsFrom(Configuration ... extendsFrom) {
        this.throwExceptionIfNotInUnresolvedState();
        for (Configuration configuration : extendsFrom) {
            if (configuration.getHierarchy().contains((Object)this)) {
                throw new InvalidUserDataException(String.format("Cyclic extendsFrom from %s and %s is not allowed. See existing hierarchy: %s", new Object[]{this, configuration, configuration.getHierarchy()}));
            }
            this.extendsFrom.add(configuration);
            this.inheritedArtifacts.addCollection((DomainObjectCollection)configuration.getAllArtifacts());
            this.inheritedDependencies.addCollection((DomainObjectCollection)configuration.getAllDependencies());
        }
        return this;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public Configuration setTransitive(boolean transitive) {
        this.throwExceptionIfNotInUnresolvedState();
        this.transitive = transitive;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Configuration setDescription(String description) {
        this.throwExceptionIfNotInUnresolvedState();
        this.description = description;
        return this;
    }

    public Set<Configuration> getHierarchy() {
        Set result = WrapUtil.toLinkedSet((Object[])new Configuration[]{this});
        this.collectSuperConfigs((Configuration)this, result);
        return result;
    }

    private void collectSuperConfigs(Configuration configuration, Set<Configuration> result) {
        for (Configuration superConfig : configuration.getExtendsFrom()) {
            if (result.contains(superConfig)) {
                result.remove(superConfig);
            }
            result.add(superConfig);
            this.collectSuperConfigs(superConfig, result);
        }
    }

    public Set<Configuration> getAll() {
        return this.configurationsProvider.getAll();
    }

    public Set<File> resolve() {
        return this.getFiles();
    }

    public Set<File> getFiles() {
        return this.fileCollection((Spec<? super Dependency>)Specs.SATISFIES_ALL).getFiles();
    }

    public Set<File> files(Dependency ... dependencies) {
        return this.fileCollection(dependencies).getFiles();
    }

    public Set<File> files(Closure dependencySpecClosure) {
        return this.fileCollection(dependencySpecClosure).getFiles();
    }

    public Set<File> files(Spec<? super Dependency> dependencySpec) {
        return this.fileCollection(dependencySpec).getFiles();
    }

    public FileCollection fileCollection(Spec<? super Dependency> dependencySpec) {
        return new ConfigurationFileCollection(dependencySpec);
    }

    public FileCollection fileCollection(Closure dependencySpecClosure) {
        return new ConfigurationFileCollection(dependencySpecClosure);
    }

    public FileCollection fileCollection(Dependency ... dependencies) {
        return new ConfigurationFileCollection(WrapUtil.toLinkedSet((Object[])dependencies));
    }

    public ResolvedConfiguration getResolvedConfiguration() {
        this.resolveNow();
        return this.cachedResolverResults.getResolvedConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveNow() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == Configuration.State.UNRESOLVED) {
                DependencyResolutionListener broadcast = this.getDependencyResolutionBroadcast();
                ResolvableDependencies incoming = this.getIncoming();
                broadcast.beforeResolve(incoming);
                this.cachedResolverResults = this.resolver.resolve(this);
                this.state = this.cachedResolverResults.getResolvedConfiguration().hasError() ? Configuration.State.RESOLVED_WITH_FAILURES : Configuration.State.RESOLVED;
                broadcast.afterResolve(incoming);
            }
        }
    }

    public TaskDependency getBuildDependencies() {
        return this.allDependencies.getBuildDependencies();
    }

    public TaskDependency getTaskDependencyFromProjectDependency(boolean useDependedOn, String taskName) {
        if (useDependedOn) {
            return new TasksFromProjectDependencies(taskName, this.getAllDependencies());
        }
        return new TasksFromDependentProjects(taskName, this.getName());
    }

    public DependencySet getDependencies() {
        return this.dependencies;
    }

    public DependencySet getAllDependencies() {
        return this.allDependencies;
    }

    public PublishArtifactSet getArtifacts() {
        return this.artifacts;
    }

    public PublishArtifactSet getAllArtifacts() {
        return this.allArtifacts;
    }

    public Set<ExcludeRule> getExcludeRules() {
        return Collections.unmodifiableSet(this.excludeRules);
    }

    public void setExcludeRules(Set<ExcludeRule> excludeRules) {
        this.throwExceptionIfNotInUnresolvedState();
        this.excludeRules = excludeRules;
    }

    public DefaultConfiguration exclude(Map<String, String> excludeRuleArgs) {
        this.throwExceptionIfNotInUnresolvedState();
        this.excludeRules.add((ExcludeRule)new ExcludeRuleNotationParser().parseNotation(excludeRuleArgs));
        return this;
    }

    public String getUploadTaskName() {
        return Configurations.uploadTaskName(this.getName());
    }

    public String getDisplayName() {
        return String.format("configuration '%s'", this.path);
    }

    public ResolvableDependencies getIncoming() {
        return this.resolvableDependencies;
    }

    public Configuration copy() {
        return this.createCopy((Set<Dependency>)this.getDependencies(), false);
    }

    public Configuration copyRecursive() {
        return this.createCopy((Set<Dependency>)this.getAllDependencies(), true);
    }

    public Configuration copy(Spec<? super Dependency> dependencySpec) {
        return this.createCopy(CollectionUtils.filter((Set)this.getDependencies(), dependencySpec), false);
    }

    public Configuration copyRecursive(Spec<? super Dependency> dependencySpec) {
        return this.createCopy(CollectionUtils.filter((Set)this.getAllDependencies(), dependencySpec), true);
    }

    private DefaultConfiguration createCopy(Set<Dependency> dependencies, boolean recursive) {
        DetachedConfigurationsProvider configurationsProvider = new DetachedConfigurationsProvider();
        DefaultConfiguration copiedConfiguration = new DefaultConfiguration(this.path + "Copy", this.name + "Copy", configurationsProvider, this.resolver, this.listenerManager, this.metaDataProvider, this.resolutionStrategy.copy());
        configurationsProvider.setTheOnlyConfiguration((Configuration)copiedConfiguration);
        copiedConfiguration.visibility = this.visibility;
        copiedConfiguration.transitive = this.transitive;
        copiedConfiguration.description = this.description;
        copiedConfiguration.getArtifacts().addAll((Collection)this.getAllArtifacts());
        LinkedHashSet<DefaultConfiguration> excludeRuleSources = new LinkedHashSet<DefaultConfiguration>();
        excludeRuleSources.add(this);
        if (recursive) {
            excludeRuleSources.addAll(this.getHierarchy());
        }
        for (Configuration configuration : excludeRuleSources) {
            for (ExcludeRule excludeRule : configuration.getExcludeRules()) {
                copiedConfiguration.excludeRules.add((ExcludeRule)new DefaultExcludeRule(excludeRule.getGroup(), excludeRule.getModule()));
            }
        }
        DependencySet copiedDependencies = copiedConfiguration.getDependencies();
        for (Dependency dependency : dependencies) {
            copiedDependencies.add((Object)dependency.copy());
        }
        return copiedConfiguration;
    }

    public Configuration copy(Closure dependencySpec) {
        return this.copy((Spec<? super Dependency>)Specs.convertClosureToSpec((Closure)dependencySpec));
    }

    public Configuration copyRecursive(Closure dependencySpec) {
        return this.copyRecursive((Spec<? super Dependency>)Specs.convertClosureToSpec((Closure)dependencySpec));
    }

    public DependencyResolutionListener getDependencyResolutionBroadcast() {
        return (DependencyResolutionListener)this.resolutionListenerBroadcast.getSource();
    }

    public ResolutionStrategyInternal getResolutionStrategy() {
        return this.resolutionStrategy;
    }

    public String getPath() {
        return this.path;
    }

    public Configuration resolutionStrategy(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.resolutionStrategy);
        return this;
    }

    private void throwExceptionIfNotInUnresolvedState() {
        if (this.getState() != Configuration.State.UNRESOLVED) {
            throw new InvalidUserDataException("You can't change configuration '" + this.getName() + "' because it is already resolved!");
        }
    }

    public String dump() {
        StringBuilder reply = new StringBuilder();
        reply.append("\nConfiguration:");
        reply.append("  class='" + ((Object)((Object)this)).getClass() + "'");
        reply.append("  name='" + this.getName() + "'");
        reply.append("  hashcode='" + ((Object)((Object)this)).hashCode() + "'");
        reply.append("\nLocal Dependencies:");
        if (this.getDependencies().size() > 0) {
            for (Dependency d : this.getDependencies()) {
                reply.append("\n   " + d);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nLocal Artifacts:");
        if (this.getArtifacts().size() > 0) {
            for (PublishArtifact a : this.getArtifacts()) {
                reply.append("\n   " + a);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nAll Dependencies:");
        if (this.getAllDependencies().size() > 0) {
            for (Dependency d : this.getAllDependencies()) {
                reply.append("\n   " + d);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nAll Artifacts:");
        if (this.getAllArtifacts().size() > 0) {
            for (PublishArtifact a : this.getAllArtifacts()) {
                reply.append("\n   " + a);
            }
        } else {
            reply.append("\n   none");
        }
        return reply.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigurationResolvableDependencies
    implements ResolvableDependencies {
        private ConfigurationResolvableDependencies() {
        }

        public String getName() {
            return DefaultConfiguration.this.name;
        }

        public String getPath() {
            return DefaultConfiguration.this.path;
        }

        public String toString() {
            return String.format("dependencies '%s'", DefaultConfiguration.this.path);
        }

        public FileCollection getFiles() {
            return DefaultConfiguration.this.fileCollection((Spec<? super Dependency>)Specs.satisfyAll());
        }

        public DependencySet getDependencies() {
            return DefaultConfiguration.this.getAllDependencies();
        }

        public void beforeResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.resolutionListenerBroadcast.add("beforeResolve", action);
        }

        public void beforeResolve(Closure action) {
            DefaultConfiguration.this.resolutionListenerBroadcast.add((Dispatch)new ClosureBackedMethodInvocationDispatch("beforeResolve", action));
        }

        public void afterResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.resolutionListenerBroadcast.add("afterResolve", action);
        }

        public void afterResolve(Closure action) {
            DefaultConfiguration.this.resolutionListenerBroadcast.add((Dispatch)new ClosureBackedMethodInvocationDispatch("afterResolve", action));
        }

        public ResolutionResult getResolutionResult() {
            DefaultConfiguration.this.resolveNow();
            return DefaultConfiguration.this.cachedResolverResults.getResolutionResult();
        }
    }

    private class VetoContainerChangeAction
    implements Runnable {
        private VetoContainerChangeAction() {
        }

        public void run() {
            DefaultConfiguration.this.throwExceptionIfNotInUnresolvedState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConfigurationFileCollection
    extends AbstractFileCollection {
        private Spec<? super Dependency> dependencySpec;

        private ConfigurationFileCollection(Spec<? super Dependency> dependencySpec) {
            this.dependencySpec = dependencySpec;
        }

        public ConfigurationFileCollection(Closure dependencySpecClosure) {
            this.dependencySpec = Specs.convertClosureToSpec((Closure)dependencySpecClosure);
        }

        public ConfigurationFileCollection(final Set<Dependency> dependencies) {
            this.dependencySpec = new Spec<Dependency>(){

                public boolean isSatisfiedBy(Dependency element) {
                    return dependencies.contains(element);
                }
            };
        }

        public TaskDependency getBuildDependencies() {
            return DefaultConfiguration.this.getBuildDependencies();
        }

        public Spec<? super Dependency> getDependencySpec() {
            return this.dependencySpec;
        }

        public String getDisplayName() {
            return String.format("%s dependencies", new Object[]{DefaultConfiguration.this});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<File> getFiles() {
            Object object = DefaultConfiguration.this.lock;
            synchronized (object) {
                ResolvedConfiguration resolvedConfiguration = DefaultConfiguration.this.getResolvedConfiguration();
                if (DefaultConfiguration.this.getState() == Configuration.State.RESOLVED_WITH_FAILURES) {
                    resolvedConfiguration.rethrowFailure();
                }
                return resolvedConfiguration.getFiles(this.dependencySpec);
            }
        }
    }
}

