/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configurations {
    public static Set<String> getNames(Collection<? extends Configuration> configurations, boolean includeExtended) {
        Set<Object> allConfigurations = new HashSet<Configuration>(configurations);
        if (includeExtended) {
            allConfigurations = Configurations.createAllConfigurations(configurations);
        }
        HashSet<String> names = new HashSet<String>();
        for (Configuration configuration : allConfigurations) {
            names.add(configuration.getName());
        }
        return names;
    }

    public static Set<String> getNames(Collection<Configuration> configurations) {
        return Configurations.getNames(configurations, false);
    }

    private static Set<Configuration> createAllConfigurations(Collection<? extends Configuration> configurations) {
        HashSet<Configuration> allConfigurations = new HashSet<Configuration>();
        for (Configuration configuration : configurations) {
            allConfigurations.addAll(configuration.getHierarchy());
        }
        return allConfigurations;
    }

    public static String uploadTaskName(String configurationName) {
        return String.format("upload%s", Configurations.getCapitalName(configurationName));
    }

    private static String getCapitalName(String configurationName) {
        return configurationName.substring(0, 1).toUpperCase() + configurationName.substring(1);
    }
}

