/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.result.ResolutionResult;

public class ResolverResults {
    private ResolvedConfiguration resolvedConfiguration;
    private ResolutionResult resolutionResult;
    private ResolveException fatalFailure;

    public ResolvedConfiguration getResolvedConfiguration() {
        this.assertHasResult();
        return this.resolvedConfiguration;
    }

    public ResolutionResult getResolutionResult() {
        this.assertHasResult();
        if (this.fatalFailure != null) {
            throw this.fatalFailure;
        }
        return this.resolutionResult;
    }

    private void assertHasResult() {
        if (this.resolvedConfiguration == null) {
            throw new IllegalStateException("Resolution result has not been attached.");
        }
    }

    public void withResolvedConfiguration(ResolvedConfiguration resolvedConfiguration) {
        this.resolvedConfiguration = resolvedConfiguration;
    }

    public void resolved(ResolvedConfiguration resolvedConfiguration, ResolutionResult resolutionResult) {
        this.resolvedConfiguration = resolvedConfiguration;
        this.resolutionResult = resolutionResult;
        this.fatalFailure = null;
    }

    public void failed(ResolvedConfiguration resolvedConfiguration, ResolveException failure) {
        this.resolvedConfiguration = resolvedConfiguration;
        this.resolutionResult = null;
        this.fatalFailure = failure;
    }
}

