/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPMarker;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;

public class PGPObjectFactory {
    BCPGInputStream in;

    public PGPObjectFactory(InputStream inputStream) {
        this.in = new BCPGInputStream(inputStream);
    }

    public PGPObjectFactory(byte[] byArray) {
        this(new ByteArrayInputStream(byArray));
    }

    public Object nextObject() throws IOException {
        switch (this.in.nextPacketTag()) {
            case -1: {
                return null;
            }
            case 2: {
                ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
                while (this.in.nextPacketTag() == 2) {
                    try {
                        arrayList.add(new PGPSignature(this.in));
                    }
                    catch (PGPException pGPException) {
                        throw new IOException("can't create signature object: " + pGPException);
                    }
                }
                return new PGPSignatureList(arrayList.toArray(new PGPSignature[arrayList.size()]));
            }
            case 5: {
                try {
                    return new PGPSecretKeyRing(this.in);
                }
                catch (PGPException pGPException) {
                    throw new IOException("can't create secret key object: " + pGPException);
                }
            }
            case 6: {
                return new PGPPublicKeyRing(this.in);
            }
            case 14: {
                return PGPPublicKeyRing.readSubkey(this.in);
            }
            case 8: {
                return new PGPCompressedData(this.in);
            }
            case 11: {
                return new PGPLiteralData(this.in);
            }
            case 1: 
            case 3: {
                return new PGPEncryptedDataList(this.in);
            }
            case 4: {
                ArrayList<PGPOnePassSignature> arrayList = new ArrayList<PGPOnePassSignature>();
                while (this.in.nextPacketTag() == 4) {
                    try {
                        arrayList.add(new PGPOnePassSignature(this.in));
                    }
                    catch (PGPException pGPException) {
                        throw new IOException("can't create one pass signature object: " + pGPException);
                    }
                }
                return new PGPOnePassSignatureList(arrayList.toArray(new PGPOnePassSignature[arrayList.size()]));
            }
            case 10: {
                return new PGPMarker(this.in);
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return this.in.readPacket();
            }
        }
        throw new IOException("unknown object in stream: " + this.in.nextPacketTag());
    }
}

