/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.repository.internal;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import org.gradle.mvn3.org.apache.maven.artifact.repository.metadata.Metadata;
import org.gradle.mvn3.org.apache.maven.artifact.repository.metadata.Snapshot;
import org.gradle.mvn3.org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.gradle.mvn3.org.apache.maven.artifact.repository.metadata.Versioning;
import org.gradle.mvn3.org.apache.maven.repository.internal.MavenMetadata;
import org.gradle.mvn3.org.sonatype.aether.artifact.Artifact;
import org.gradle.mvn3.org.sonatype.aether.metadata.Metadata;

final class RemoteSnapshotMetadata
extends MavenMetadata {
    private static final String SNAPSHOT = "SNAPSHOT";
    private final Collection<Artifact> artifacts = new ArrayList<Artifact>();
    private final Map<String, SnapshotVersion> versions = new LinkedHashMap<String, SnapshotVersion>();
    private final boolean legacyFormat;

    public RemoteSnapshotMetadata(Artifact artifact, boolean legacyFormat) {
        super(RemoteSnapshotMetadata.createMetadata(artifact, legacyFormat), null);
        this.legacyFormat = legacyFormat;
    }

    private RemoteSnapshotMetadata(Metadata metadata, File file, boolean legacyFormat) {
        super(metadata, file);
        this.legacyFormat = legacyFormat;
    }

    private static Metadata createMetadata(Artifact artifact, boolean legacyFormat) {
        Metadata metadata = new Metadata();
        if (!legacyFormat) {
            metadata.setModelVersion("1.1.0");
        }
        metadata.setGroupId(artifact.getGroupId());
        metadata.setArtifactId(artifact.getArtifactId());
        metadata.setVersion(artifact.getBaseVersion());
        return metadata;
    }

    public void bind(Artifact artifact) {
        this.artifacts.add(artifact);
    }

    public MavenMetadata setFile(File file) {
        return new RemoteSnapshotMetadata(this.metadata, file, this.legacyFormat);
    }

    public Object getKey() {
        return this.getGroupId() + ':' + this.getArtifactId() + ':' + this.getVersion();
    }

    public static Object getKey(Artifact artifact) {
        return artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getBaseVersion();
    }

    public String getExpandedVersion(Artifact artifact) {
        String key = this.getKey(artifact.getClassifier(), artifact.getExtension());
        return this.versions.get(key).getVersion();
    }

    protected void merge(Metadata recessive) {
        Snapshot snapshot;
        String lastUpdated = "";
        if (this.metadata.getVersioning() == null) {
            SimpleDateFormat utcDateFormatter = new SimpleDateFormat("yyyyMMdd.HHmmss");
            utcDateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            snapshot = new Snapshot();
            snapshot.setBuildNumber(RemoteSnapshotMetadata.getBuildNumber(recessive) + 1);
            snapshot.setTimestamp(utcDateFormatter.format(new Date()));
            Versioning versioning = new Versioning();
            versioning.setSnapshot(snapshot);
            versioning.setLastUpdated(snapshot.getTimestamp().replace(".", ""));
            lastUpdated = versioning.getLastUpdated();
            this.metadata.setVersioning(versioning);
        } else {
            snapshot = this.metadata.getVersioning().getSnapshot();
            lastUpdated = this.metadata.getVersioning().getLastUpdated();
        }
        for (Artifact artifact : this.artifacts) {
            String version = artifact.getVersion();
            if (version.endsWith(SNAPSHOT)) {
                String qualifier = snapshot.getTimestamp() + "-" + snapshot.getBuildNumber();
                version = version.substring(0, version.length() - SNAPSHOT.length()) + qualifier;
            }
            SnapshotVersion sv = new SnapshotVersion();
            sv.setClassifier(artifact.getClassifier());
            sv.setExtension(artifact.getExtension());
            sv.setVersion(version);
            sv.setUpdated(lastUpdated);
            this.versions.put(this.getKey(sv.getClassifier(), sv.getExtension()), sv);
        }
        this.artifacts.clear();
        Versioning versioning = recessive.getVersioning();
        if (versioning != null) {
            for (SnapshotVersion sv : versioning.getSnapshotVersions()) {
                String key = this.getKey(sv.getClassifier(), sv.getExtension());
                if (this.versions.containsKey(key)) continue;
                this.versions.put(key, sv);
            }
        }
        if (!this.legacyFormat) {
            this.metadata.getVersioning().setSnapshotVersions(new ArrayList<SnapshotVersion>(this.versions.values()));
        }
    }

    private String getKey(String classifier, String extension) {
        return classifier + ':' + extension;
    }

    private static int getBuildNumber(Metadata metadata) {
        Snapshot snapshot;
        int number = 0;
        Versioning versioning = metadata.getVersioning();
        if (versioning != null && (snapshot = versioning.getSnapshot()) != null && snapshot.getBuildNumber() > 0) {
            number = snapshot.getBuildNumber();
        }
        return number;
    }

    public String getGroupId() {
        return this.metadata.getGroupId();
    }

    public String getArtifactId() {
        return this.metadata.getArtifactId();
    }

    public String getVersion() {
        return this.metadata.getVersion();
    }

    public Metadata.Nature getNature() {
        return Metadata.Nature.SNAPSHOT;
    }
}

