/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Buildable;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.LazilyInitializedFileCollection;
import org.gradle.api.internal.plugins.GroovyJarFile;
import org.gradle.api.tasks.TaskDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class GroovyRuntime {
    private final Project project;

    public GroovyRuntime(Project project) {
        this.project = project;
    }

    public FileCollection inferGroovyClasspath(final Iterable<File> classpath) {
        return new LazilyInitializedFileCollection(){

            public FileCollection createDelegate() {
                GroovyJarFile groovyJar = GroovyRuntime.this.findGroovyJarFile(classpath);
                if (groovyJar == null) {
                    throw new GradleException(String.format("Cannot infer Groovy class path because no Groovy Jar was found on class path: %s", classpath));
                }
                if (groovyJar.isGroovyAll()) {
                    return GroovyRuntime.this.project.files(new Object[]{groovyJar.getFile()});
                }
                if (GroovyRuntime.this.project.getRepositories().isEmpty()) {
                    throw new GradleException("Cannot infer Groovy class path because no repository is declared for the project.");
                }
                String notation = groovyJar.getDependencyNotation();
                ArrayList dependencies = Lists.newArrayList();
                dependencies.add(GroovyRuntime.this.project.getDependencies().create((Object)notation));
                if (groovyJar.getVersion().getMajor() >= 2) {
                    dependencies.add(GroovyRuntime.this.project.getDependencies().create((Object)notation.replace(":groovy:", ":groovy-ant:")));
                }
                return GroovyRuntime.this.project.getConfigurations().detachedConfiguration(dependencies.toArray(new Dependency[dependencies.size()]));
            }

            public TaskDependency getBuildDependencies() {
                if (classpath instanceof Buildable) {
                    return ((Buildable)classpath).getBuildDependencies();
                }
                return new TaskDependency(){

                    public Set<? extends Task> getDependencies(Task task) {
                        return Collections.emptySet();
                    }
                };
            }
        };
    }

    private GroovyJarFile findGroovyJarFile(Iterable<File> classpath) {
        if (classpath == null) {
            return null;
        }
        for (File file : classpath) {
            GroovyJarFile groovyJar = GroovyJarFile.parse(file);
            if (groovyJar == null) continue;
            return groovyJar;
        }
        return null;
    }
}

