/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.java.WebApplication;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.War;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarPlugin
implements Plugin<Project> {
    public static final String PROVIDED_COMPILE_CONFIGURATION_NAME = "providedCompile";
    public static final String PROVIDED_RUNTIME_CONFIGURATION_NAME = "providedRuntime";
    public static final String WAR_TASK_NAME = "war";
    public static final String WEB_APP_GROUP = "web application";

    public void apply(final Project project) {
        project.getPlugins().apply(JavaPlugin.class);
        final WarPluginConvention pluginConvention = new WarPluginConvention(project);
        project.getConvention().getPlugins().put(WAR_TASK_NAME, pluginConvention);
        project.getTasks().withType(War.class, (Action)new Action<War>(){

            public void execute(War task) {
                task.from(new Object[]{new Callable(){

                    public Object call() throws Exception {
                        return pluginConvention.getWebAppDir();
                    }
                }});
                task.dependsOn(new Object[]{new Callable(){

                    public Object call() throws Exception {
                        return ((SourceSet)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getRuntimeClasspath();
                    }
                }});
                task.classpath(new Callable(){

                    public Object call() throws Exception {
                        FileCollection runtimeClasspath = ((SourceSet)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getRuntimeClasspath();
                        Configuration providedRuntime = project.getConfigurations().getByName(WarPlugin.PROVIDED_RUNTIME_CONFIGURATION_NAME);
                        return runtimeClasspath.minus((FileCollection)providedRuntime);
                    }
                });
            }
        });
        War war = (War)project.getTasks().create(WAR_TASK_NAME, War.class);
        war.setDescription("Generates a war archive with all the compiled classes, the web-app content and the libraries.");
        war.setGroup("build");
        ArchivePublishArtifact warArtifact = new ArchivePublishArtifact((AbstractArchiveTask)war);
        ((DefaultArtifactPublicationSet)project.getExtensions().getByType(DefaultArtifactPublicationSet.class)).addCandidate((PublishArtifact)warArtifact);
        this.configureConfigurations(project.getConfigurations());
        this.configureComponent(project, (PublishArtifact)warArtifact);
    }

    public void configureConfigurations(ConfigurationContainer configurationContainer) {
        Configuration provideCompileConfiguration = ((Configuration)configurationContainer.create(PROVIDED_COMPILE_CONFIGURATION_NAME)).setVisible(false).setDescription("Additional compile classpath for libraries that should not be part of the WAR archive.");
        Configuration provideRuntimeConfiguration = ((Configuration)configurationContainer.create(PROVIDED_RUNTIME_CONFIGURATION_NAME)).setVisible(false).extendsFrom(new Configuration[]{provideCompileConfiguration}).setDescription("Additional runtime classpath for libraries that should not be part of the WAR archive.");
        configurationContainer.getByName("compile").extendsFrom(new Configuration[]{provideCompileConfiguration});
        configurationContainer.getByName("runtime").extendsFrom(new Configuration[]{provideRuntimeConfiguration});
    }

    private void configureComponent(Project project, PublishArtifact warArtifact) {
        project.getComponents().add((Object)new WebApplication(warArtifact));
    }
}

