/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.jvm.ClassDirectoryBinarySpecInternal;
import org.gradle.api.internal.jvm.DefaultClassDirectoryBinarySpec;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.jvm.ClassDirectoryBinarySpec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.plugins.LanguageBasePlugin;
import org.gradle.language.java.JavaSourceSet;
import org.gradle.language.jvm.ResourceSet;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.runtime.base.BinaryContainer;
import org.gradle.runtime.base.internal.BinaryNamingScheme;
import org.gradle.runtime.jvm.toolchain.JavaToolChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class LegacyJavaComponentPlugin
implements Plugin<Project> {
    private final Instantiator instantiator;
    private final JavaToolChain toolChain;

    @Inject
    public LegacyJavaComponentPlugin(Instantiator instantiator, JavaToolChain toolChain) {
        this.instantiator = instantiator;
        this.toolChain = toolChain;
    }

    public void apply(final Project target) {
        target.getPlugins().apply(LanguageBasePlugin.class);
        BinaryContainer binaryContainer = (BinaryContainer)target.getExtensions().getByType(BinaryContainer.class);
        binaryContainer.registerFactory(ClassDirectoryBinarySpec.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<ClassDirectoryBinarySpec>(){

            public ClassDirectoryBinarySpec create(String name) {
                return (ClassDirectoryBinarySpec)LegacyJavaComponentPlugin.this.instantiator.newInstance(DefaultClassDirectoryBinarySpec.class, new Object[]{name, LegacyJavaComponentPlugin.this.toolChain});
            }
        });
        binaryContainer.withType(ClassDirectoryBinarySpecInternal.class).all((Action)new Action<ClassDirectoryBinarySpecInternal>(){

            public void execute(ClassDirectoryBinarySpecInternal binary) {
                LegacyJavaComponentPlugin.this.createBinaryLifecycleTask(binary, target);
                LegacyJavaComponentPlugin.this.setClassesDirConvention(binary, target);
                LegacyJavaComponentPlugin.this.createProcessResourcesTaskForBinary(binary, target);
                LegacyJavaComponentPlugin.this.createCompileJavaTaskForBinary(binary, target);
            }
        });
    }

    private void setClassesDirConvention(ClassDirectoryBinarySpecInternal binary, final Project target) {
        final BinaryNamingScheme namingScheme = binary.getNamingScheme();
        ConventionMapping conventionMapping = new DslObject((Object)binary).getConventionMapping();
        conventionMapping.map("classesDir", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(new File(target.getBuildDir(), "classes"), namingScheme.getOutputDirectoryBase());
            }
        });
    }

    private void createCompileJavaTaskForBinary(final ClassDirectoryBinarySpecInternal binary, final Project target) {
        final BinaryNamingScheme namingScheme = binary.getNamingScheme();
        binary.getSource().withType(JavaSourceSet.class).all((Action)new Action<JavaSourceSet>(){

            public void execute(JavaSourceSet javaSourceSet) {
                JavaCompile compileTask = (JavaCompile)target.getTasks().create(namingScheme.getTaskName("compile", "java"), JavaCompile.class);
                LegacyJavaComponentPlugin.this.configureCompileTask((AbstractCompile)compileTask, javaSourceSet, binary);
                binary.getTasks().add((Object)compileTask);
                binary.builtBy(new Object[]{compileTask});
            }
        });
    }

    private void createProcessResourcesTaskForBinary(final ClassDirectoryBinarySpecInternal binary, final Project target) {
        final BinaryNamingScheme namingScheme = binary.getNamingScheme();
        binary.getSource().withType(ResourceSet.class).all((Action)new Action<ResourceSet>(){

            public void execute(ResourceSet resourceSet) {
                Copy resourcesTask = (Copy)target.getTasks().create(namingScheme.getTaskName("process", "resources"), ProcessResources.class);
                resourcesTask.setDescription(String.format("Processes %s.", resourceSet));
                new DslObject((Object)resourcesTask).getConventionMapping().map("destinationDir", (Callable)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return binary.getResourcesDir();
                    }
                });
                binary.getTasks().add((Object)resourcesTask);
                binary.builtBy(new Object[]{resourcesTask});
                resourcesTask.from(new Object[]{resourceSet.getSource()});
            }
        });
    }

    private void createBinaryLifecycleTask(ClassDirectoryBinarySpecInternal binary, Project target) {
        Task binaryLifecycleTask = target.task(binary.getNamingScheme().getLifecycleTaskName());
        binaryLifecycleTask.setGroup("build");
        binaryLifecycleTask.setDescription(String.format("Assembles %s.", binary));
        binary.setBuildTask(binaryLifecycleTask);
    }

    public void configureCompileTask(AbstractCompile compile, final JavaSourceSet sourceSet, final ClassDirectoryBinarySpec binary) {
        compile.setDescription(String.format("Compiles %s.", sourceSet));
        compile.setSource((Object)sourceSet.getSource());
        compile.dependsOn(new Object[]{sourceSet});
        ConventionMapping conventionMapping = compile.getConventionMapping();
        conventionMapping.map("classpath", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return sourceSet.getCompileClasspath().getFiles();
            }
        });
        conventionMapping.map("destinationDir", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return binary.getClassesDir();
            }
        });
    }
}

