/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultGroovySourceSet;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.GroovyRuntime;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.javadoc.Groovydoc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyBasePlugin
implements Plugin<ProjectInternal> {
    public static final String GROOVY_RUNTIME_EXTENSION_NAME = "groovyRuntime";
    private final FileResolver fileResolver;
    private ProjectInternal project;
    private GroovyRuntime groovyRuntime;

    @Inject
    public GroovyBasePlugin(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public void apply(ProjectInternal project) {
        this.project = project;
        JavaBasePlugin javaBasePlugin = (JavaBasePlugin)project.getPlugins().apply(JavaBasePlugin.class);
        this.configureGroovyRuntimeExtension();
        this.configureCompileDefaults();
        this.configureSourceSetDefaults(javaBasePlugin);
        this.configureGroovydoc();
    }

    private void configureGroovyRuntimeExtension() {
        this.groovyRuntime = (GroovyRuntime)this.project.getExtensions().create(GROOVY_RUNTIME_EXTENSION_NAME, GroovyRuntime.class, new Object[]{this.project});
    }

    private void configureCompileDefaults() {
        this.project.getTasks().withType(GroovyCompile.class, (Action)new Action<GroovyCompile>(){

            public void execute(final GroovyCompile compile) {
                compile.getConventionMapping().map("groovyClasspath", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return GroovyBasePlugin.this.groovyRuntime.inferGroovyClasspath((Iterable<File>)compile.getClasspath());
                    }
                });
            }
        });
    }

    private void configureSourceSetDefaults(final JavaBasePlugin javaBasePlugin) {
        ((JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all((Action)new Action<SourceSet>(){

            public void execute(SourceSet sourceSet) {
                final DefaultGroovySourceSet groovySourceSet = new DefaultGroovySourceSet(((DefaultSourceSet)sourceSet).getDisplayName(), GroovyBasePlugin.this.fileResolver);
                new DslObject((Object)sourceSet).getConvention().getPlugins().put("groovy", groovySourceSet);
                groovySourceSet.getGroovy().srcDir((Object)String.format("src/%s/groovy", sourceSet.getName()));
                sourceSet.getResources().getFilter().exclude((Spec)new Spec<FileTreeElement>(){

                    public boolean isSatisfiedBy(FileTreeElement element) {
                        return groovySourceSet.getGroovy().contains(element.getFile());
                    }
                });
                sourceSet.getAllJava().source(groovySourceSet.getGroovy());
                sourceSet.getAllSource().source(groovySourceSet.getGroovy());
                String compileTaskName = sourceSet.getCompileTaskName("groovy");
                GroovyCompile compile = (GroovyCompile)GroovyBasePlugin.this.project.getTasks().create(compileTaskName, GroovyCompile.class);
                javaBasePlugin.configureForSourceSet(sourceSet, (AbstractCompile)compile);
                compile.dependsOn(new Object[]{sourceSet.getCompileJavaTaskName()});
                compile.setDescription(String.format("Compiles the %s Groovy source.", sourceSet.getName()));
                compile.setSource((Object)groovySourceSet.getGroovy());
                GroovyBasePlugin.this.project.getTasks().getByName(sourceSet.getClassesTaskName()).dependsOn(new Object[]{compileTaskName});
            }
        });
    }

    private void configureGroovydoc() {
        this.project.getTasks().withType(Groovydoc.class, (Action)new Action<Groovydoc>(){

            public void execute(final Groovydoc groovydoc) {
                groovydoc.getConventionMapping().map("groovyClasspath", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return GroovyBasePlugin.this.groovyRuntime.inferGroovyClasspath((Iterable<File>)groovydoc.getClasspath());
                    }
                });
                groovydoc.getConventionMapping().map("destinationDir", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return new File(GroovyBasePlugin.this.java(GroovyBasePlugin.this.project.getConvention()).getDocsDir(), "groovydoc");
                    }
                });
                groovydoc.getConventionMapping().map("docTitle", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((ReportingExtension)GroovyBasePlugin.this.project.getExtensions().getByType(ReportingExtension.class)).getApiDocTitle();
                    }
                });
                groovydoc.getConventionMapping().map("windowTitle", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((ReportingExtension)GroovyBasePlugin.this.project.getExtensions().getByType(ReportingExtension.class)).getApiDocTitle();
                    }
                });
            }
        });
    }

    private JavaPluginConvention java(Convention convention) {
        return (JavaPluginConvention)convention.getPlugin(JavaPluginConvention.class);
    }
}

