/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher;
import org.gradle.api.internal.tasks.testing.processors.CaptureTestOutputTestResultProcessor;
import org.gradle.api.internal.tasks.testing.testng.TestNGListenerAdapterFactory;
import org.gradle.api.internal.tasks.testing.testng.TestNGSpec;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestResultProcessorAdapter;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.reflect.NoSuchMethodException;
import org.gradle.logging.StandardOutputRedirector;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GFileUtils;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.TestNG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGTestClassProcessor
implements TestClassProcessor {
    private final List<Class<?>> testClasses = new ArrayList();
    private final File testReportDir;
    private final TestNGSpec options;
    private final List<File> suiteFiles;
    private final IdGenerator<?> idGenerator;
    private final StandardOutputRedirector outputRedirector;
    private TestNGTestResultProcessorAdapter testResultProcessor;
    private ClassLoader applicationClassLoader;

    public TestNGTestClassProcessor(File testReportDir, TestNGSpec options, List<File> suiteFiles, IdGenerator<?> idGenerator, StandardOutputRedirector outputRedirector) {
        this.testReportDir = testReportDir;
        this.options = options;
        this.suiteFiles = suiteFiles;
        this.idGenerator = idGenerator;
        this.outputRedirector = outputRedirector;
    }

    @Override
    public void startProcessing(TestResultProcessor resultProcessor) {
        CaptureTestOutputTestResultProcessor resultProcessorChain = new CaptureTestOutputTestResultProcessor(resultProcessor, this.outputRedirector);
        this.testResultProcessor = new TestNGTestResultProcessorAdapter(resultProcessorChain, this.idGenerator);
        this.applicationClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public void processTestClass(TestClassRunInfo testClass) {
        try {
            this.testClasses.add(this.applicationClassLoader.loadClass(testClass.getTestClassName()));
        }
        catch (Throwable e) {
            throw new GradleException(String.format("Could not load test class '%s'.", testClass.getTestClassName()), e);
        }
    }

    @Override
    public void stop() {
        TestNG testNg = new TestNG();
        testNg.setOutputDirectory(this.testReportDir.getAbsolutePath());
        testNg.setDefaultSuiteName(this.options.getDefaultSuiteName());
        testNg.setDefaultTestName(this.options.getDefaultTestName());
        testNg.setParallel(this.options.getParallel());
        testNg.setThreadCount(this.options.getThreadCount());
        try {
            JavaReflectionUtil.method(TestNG.class, Object.class, (String)"setAnnotations", (Class[])new Class[0]).invoke((Object)testNg, new Object[]{this.options.getAnnotations()});
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (this.options.getJavadocAnnotations()) {
            testNg.setSourcePath(CollectionUtils.join((String)File.pathSeparator, (Iterable)this.options.getTestResources()));
        }
        testNg.setUseDefaultListeners(this.options.getUseDefaultListeners());
        testNg.setVerbose(0);
        testNg.setGroups(CollectionUtils.join((String)",", this.options.getIncludeGroups()));
        testNg.setExcludedGroups(CollectionUtils.join((String)",", this.options.getExcludeGroups()));
        for (String listenerClass : this.options.getListeners()) {
            try {
                testNg.addListener(this.applicationClassLoader.loadClass(listenerClass).newInstance());
            }
            catch (Throwable e) {
                throw new GradleException(String.format("Could not add a test listener with class '%s'.", listenerClass), e);
            }
        }
        testNg.addListener((Object)this.adaptListener(this.testResultProcessor));
        if (!this.options.getIncludedTests().isEmpty()) {
            testNg.addListener((Object)new SelectedTestsFilter(this.options.getIncludedTests()));
        }
        if (!this.suiteFiles.isEmpty()) {
            testNg.setTestSuites(GFileUtils.toPaths(this.suiteFiles));
        } else {
            testNg.setTestClasses(this.testClasses.toArray(new Class[this.testClasses.size()]));
        }
        testNg.run();
    }

    private ITestListener adaptListener(ITestListener listener) {
        TestNGListenerAdapterFactory factory = new TestNGListenerAdapterFactory(this.applicationClassLoader);
        return factory.createAdapter(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SelectedTestsFilter
    implements IMethodInterceptor {
        private final TestSelectionMatcher matcher;

        public SelectedTestsFilter(Set<String> includedTests) {
            this.matcher = new TestSelectionMatcher(includedTests);
        }

        public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
            LinkedList<IMethodInstance> filtered = new LinkedList<IMethodInstance>();
            for (IMethodInstance candidate : methods) {
                if (!this.matcher.matchesTest(candidate.getMethod().getTestClass().getName(), candidate.getMethod().getMethodName())) continue;
                filtered.add(candidate);
            }
            return filtered;
        }
    }
}

