/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results;

import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.results.DefaultTestResult;
import org.gradle.api.internal.tasks.testing.results.StateTrackingTestResultProcessor;
import org.gradle.api.internal.tasks.testing.results.TestState;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestOutputListener;

public class TestListenerAdapter
extends StateTrackingTestResultProcessor {
    private final TestListener testListener;
    private final TestOutputListener testOutputListener;

    public TestListenerAdapter(TestListener testListener, TestOutputListener testOutputListener) {
        this.testListener = testListener;
        this.testOutputListener = testOutputListener;
    }

    protected void started(TestState state) {
        TestDescriptorInternal test = state.test;
        if (test.isComposite()) {
            this.testListener.beforeSuite(test);
        } else {
            this.testListener.beforeTest(test);
        }
    }

    protected void completed(TestState state) {
        DefaultTestResult result = new DefaultTestResult(state);
        TestDescriptorInternal test = state.test;
        if (test.isComposite()) {
            this.testListener.afterSuite(test, result);
        } else {
            this.testListener.afterTest(test, result);
        }
    }

    public void output(TestDescriptor test, TestOutputEvent event) {
        this.testOutputListener.onOutput(test, event);
    }
}

