/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.tasks.testing.DecoratingTestDescriptor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.TestState;
import org.gradle.api.internal.tasks.testing.results.UnknownTestDescriptor;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestOutputEvent;

public abstract class StateTrackingTestResultProcessor
implements TestResultProcessor {
    private final Map<Object, TestState> executing = new HashMap<Object, TestState>();
    private TestDescriptor currentParent;

    public final void started(TestDescriptorInternal test, TestStartEvent event) {
        TestDescriptorInternal parent = null;
        if (event.getParentId() != null) {
            parent = this.executing.get((Object)event.getParentId()).test;
        }
        TestState state = new TestState(new DecoratingTestDescriptor(test, parent), event, this.executing);
        TestState oldState = this.executing.put(test.getId(), state);
        if (oldState != null) {
            throw new IllegalArgumentException(String.format("Received a start event for %s with duplicate id '%s'.", test, test.getId()));
        }
        this.started(state);
    }

    public final void completed(Object testId, TestCompleteEvent event) {
        TestState testState = this.executing.remove(testId);
        if (testState == null) {
            throw new IllegalArgumentException(String.format("Received a completed event for test with unknown id '%s'. Registered test ids: '%s'", testId, this.executing.keySet()));
        }
        this.currentParent = testState.test.getParent();
        testState.completed(event);
        this.completed(testState);
    }

    public final void failure(Object testId, Throwable result) {
        TestState testState = this.executing.get(testId);
        if (testState == null) {
            throw new IllegalArgumentException(String.format("Received a failure event for test with unknown id '%s'. Registered test ids: '%s'", testId, this.executing.keySet()));
        }
        testState.failures.add(result);
    }

    public final void output(Object testId, TestOutputEvent event) {
        this.output(this.findDescriptor(testId), event);
    }

    private TestDescriptor findDescriptor(Object testId) {
        TestState state = this.executing.get(testId);
        if (state != null) {
            return state.test;
        }
        TestDescriptor d = this.currentParent;
        if (d != null) {
            return d;
        }
        return new UnknownTestDescriptor();
    }

    protected void output(TestDescriptor descriptor, TestOutputEvent event) {
    }

    protected void started(TestState state) {
    }

    protected void completed(TestState state) {
    }
}

