/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.report;

import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.internal.html.SimpleHtmlWriter;
import org.gradle.api.internal.tasks.testing.junit.report.CompositeTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.TestResult;
import org.gradle.internal.ErroringAction;
import org.gradle.reporting.ReportRenderer;
import org.gradle.reporting.TabbedPageRenderer;
import org.gradle.reporting.TabsRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PageRenderer<T extends CompositeTestResults>
extends TabbedPageRenderer<T> {
    private T results;
    private final TabsRenderer<T> tabsRenderer = new TabsRenderer();

    PageRenderer() {
    }

    protected T getResults() {
        return this.results;
    }

    protected abstract void renderBreadcrumbs(SimpleHtmlWriter var1) throws IOException;

    protected abstract void registerTabs();

    protected void addTab(String title, final Action<SimpleHtmlWriter> contentRenderer) {
        this.tabsRenderer.add(title, new ReportRenderer<T, SimpleHtmlWriter>(){

            public void render(T model, SimpleHtmlWriter writer) {
                contentRenderer.execute((Object)writer);
            }
        });
    }

    protected void renderTabs(SimpleHtmlWriter htmlWriter) throws IOException {
        this.tabsRenderer.render(this.getModel(), htmlWriter);
    }

    protected void addFailuresTab() {
        if (!((CompositeTestResults)this.results).getFailures().isEmpty()) {
            this.addTab("Failed tests", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                public void doExecute(SimpleHtmlWriter element) throws IOException {
                    PageRenderer.this.renderFailures(element);
                }
            });
        }
    }

    protected void renderFailures(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("ul").attribute("class", "linkList");
        for (TestResult test : ((CompositeTestResults)this.results).getFailures()) {
            htmlWriter.startElement("li");
            htmlWriter.startElement("a").attribute("href", this.asHtmlLinkEncoded(((CompositeTestResults)this.getResults()).getUrlTo(test.getClassResults()))).characters((CharSequence)test.getClassResults().getSimpleName()).endElement();
            htmlWriter.characters((CharSequence)".");
            htmlWriter.startElement("a").attribute("href", String.format("%s#%s", this.asHtmlLinkEncoded(((CompositeTestResults)this.getResults()).getUrlTo(test.getClassResults())), test.getName())).characters((CharSequence)test.getName()).endElement();
            htmlWriter.endElement();
        }
        htmlWriter.endElement();
    }

    protected void addIgnoredTab() {
        if (!((CompositeTestResults)this.results).getIgnored().isEmpty()) {
            this.addTab("Ignored tests", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                public void doExecute(SimpleHtmlWriter htmlWriter) throws IOException {
                    PageRenderer.this.renderIgnoredTests(htmlWriter);
                }
            });
        }
    }

    protected void renderIgnoredTests(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("ul").attribute("class", "linkList");
        for (TestResult test : ((CompositeTestResults)this.getResults()).getIgnored()) {
            htmlWriter.startElement("li");
            htmlWriter.startElement("a").attribute("href", this.asHtmlLinkEncoded(((CompositeTestResults)this.getResults()).getUrlTo(test.getClassResults()))).characters((CharSequence)test.getClassResults().getSimpleName()).endElement();
            htmlWriter.characters((CharSequence)".");
            htmlWriter.startElement("a").attribute("href", String.format("%s#%s", this.asHtmlLinkEncoded(((CompositeTestResults)this.getResults()).getUrlTo(test.getClassResults())), test.getName())).characters((CharSequence)test.getName()).endElement();
            htmlWriter.endElement();
        }
        htmlWriter.endElement();
    }

    protected String getTitle() {
        return ((CompositeTestResults)this.getModel()).getTitle();
    }

    protected String getPageTitle() {
        return String.format("Test results - %s", ((CompositeTestResults)this.getModel()).getTitle());
    }

    protected ReportRenderer<T, SimpleHtmlWriter> getHeaderRenderer() {
        return new ReportRenderer<T, SimpleHtmlWriter>(){

            public void render(T model, SimpleHtmlWriter htmlWriter) throws IOException {
                PageRenderer.this.results = model;
                PageRenderer.this.renderBreadcrumbs(htmlWriter);
                htmlWriter.startElement("div").attribute("id", "summary");
                htmlWriter.startElement("table");
                htmlWriter.startElement("tr");
                htmlWriter.startElement("td");
                htmlWriter.startElement("div").attribute("class", "summaryGroup");
                htmlWriter.startElement("table");
                htmlWriter.startElement("tr");
                htmlWriter.startElement("td");
                htmlWriter.startElement("div").attribute("class", "infoBox").attribute("id", "tests");
                htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)Integer.toString(PageRenderer.this.results.getTestCount())).endElement();
                htmlWriter.startElement("p").characters((CharSequence)"tests").endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.startElement("td");
                htmlWriter.startElement("div").attribute("class", "infoBox").attribute("id", "failures");
                htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)Integer.toString(PageRenderer.this.results.getFailureCount())).endElement();
                htmlWriter.startElement("p").characters((CharSequence)"failures").endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.startElement("td");
                htmlWriter.startElement("div").attribute("class", "infoBox").attribute("id", "ignored");
                htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)Integer.toString(PageRenderer.this.results.getIgnoredCount())).endElement();
                htmlWriter.startElement("p").characters((CharSequence)"ignored").endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.startElement("td");
                htmlWriter.startElement("div").attribute("class", "infoBox").attribute("id", "duration");
                htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)PageRenderer.this.results.getFormattedDuration()).endElement();
                htmlWriter.startElement("p").characters((CharSequence)"duration").endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.startElement("td");
                htmlWriter.startElement("div").attribute("class", String.format("infoBox %s", PageRenderer.this.results.getStatusClass())).attribute("id", "successRate");
                htmlWriter.startElement("div").attribute("class", "percent").characters((CharSequence)PageRenderer.this.results.getFormattedSuccessRate()).endElement();
                htmlWriter.startElement("p").characters((CharSequence)"successful").endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
            }
        };
    }

    protected ReportRenderer<T, SimpleHtmlWriter> getContentRenderer() {
        return new ReportRenderer<T, SimpleHtmlWriter>(){

            public void render(T model, SimpleHtmlWriter htmlWriter) throws IOException {
                PageRenderer.this.results = model;
                PageRenderer.this.tabsRenderer.clear();
                PageRenderer.this.registerTabs();
                PageRenderer.this.renderTabs(htmlWriter);
            }
        };
    }

    protected String asHtmlLinkEncoded(String rawLink) {
        return rawLink.replaceAll("#", "%23");
    }
}

