/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.tasks.diagnostics.AbstractReportTask;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.logging.StyledTextOutput;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectReportTask
extends AbstractReportTask {
    private TextReportRenderer renderer = new TextReportRenderer();

    @Override
    protected TextReportRenderer getRenderer() {
        return this.renderer;
    }

    @Inject
    protected BuildClientMetaData getClientMetaData() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void generate(Project project) throws IOException {
        BuildClientMetaData metaData = this.getClientMetaData();
        StyledTextOutput textOutput = this.getRenderer().getTextOutput();
        this.render(project, new GraphRenderer(textOutput), true, textOutput);
        if (project.getChildProjects().isEmpty()) {
            textOutput.withStyle(StyledTextOutput.Style.Info).text((Object)"No sub-projects");
            textOutput.println();
        }
        textOutput.println();
        textOutput.text((Object)"To see a list of the tasks of a project, run ");
        metaData.describeCommand((Appendable)textOutput.withStyle(StyledTextOutput.Style.UserInput), new String[]{String.format("<project-path>:%s", "tasks")});
        textOutput.println();
        textOutput.text((Object)"For example, try running ");
        Project exampleProject = project.getChildProjects().isEmpty() ? project : this.getChildren(project).get(0);
        metaData.describeCommand((Appendable)textOutput.withStyle(StyledTextOutput.Style.UserInput), new String[]{exampleProject.absoluteProjectPath("tasks")});
        textOutput.println();
        if (project != project.getRootProject()) {
            textOutput.println();
            textOutput.text((Object)"To see a list of all the projects in this build, run ");
            metaData.describeCommand((Appendable)textOutput.withStyle(StyledTextOutput.Style.UserInput), new String[]{project.getRootProject().absoluteProjectPath("projects")});
            textOutput.println();
        }
    }

    private void render(final Project project, GraphRenderer renderer, boolean lastChild, final StyledTextOutput textOutput) {
        renderer.visit((Action)new Action<StyledTextOutput>(){

            public void execute(StyledTextOutput styledTextOutput) {
                styledTextOutput.text((Object)StringUtils.capitalize((String)project.toString()));
                if (GUtil.isTrue((Object)project.getDescription())) {
                    textOutput.withStyle(StyledTextOutput.Style.Description).format(" - %s", new Object[]{project.getDescription()});
                }
            }
        }, lastChild);
        renderer.startChildren();
        List<Project> children = this.getChildren(project);
        for (Project child : children) {
            this.render(child, renderer, child == children.get(children.size() - 1), textOutput);
        }
        renderer.completeChildren();
    }

    private List<Project> getChildren(Project project) {
        return CollectionUtils.sort(project.getChildProjects().values());
    }
}

