/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.components.internal;

import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.reporting.components.internal.BinaryRenderer;
import org.gradle.api.reporting.components.internal.SourceSetRenderer;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.reporting.ReportRenderer;
import org.gradle.runtime.base.ComponentSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRenderer
extends ReportRenderer<ComponentSpec, TextReportBuilder> {
    private final SourceSetRenderer sourceSetRenderer;
    private final BinaryRenderer renderer;

    public ComponentRenderer(FileResolver fileResolver) {
        this.sourceSetRenderer = new SourceSetRenderer(fileResolver);
        this.renderer = new BinaryRenderer(fileResolver);
    }

    public void render(ComponentSpec component, TextReportBuilder builder) {
        builder.subheading(StringUtils.capitalize((String)component.getDisplayName()));
        builder.getOutput().println();
        builder.collection("Source sets", component.getSource(), this.sourceSetRenderer, "source sets");
        builder.getOutput().println();
        builder.collection("Binaries", component.getBinaries(), this.renderer, "binaries");
    }
}

