/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.components.internal;

import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.jvm.ClassDirectoryBinarySpec;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.logging.StyledTextOutput;
import org.gradle.nativebinaries.NativeBinarySpec;
import org.gradle.nativebinaries.NativeExecutableBinarySpec;
import org.gradle.nativebinaries.SharedLibraryBinarySpec;
import org.gradle.nativebinaries.StaticLibraryBinarySpec;
import org.gradle.nativebinaries.test.NativeTestSuiteBinarySpec;
import org.gradle.reporting.ReportRenderer;
import org.gradle.runtime.base.BinarySpec;
import org.gradle.runtime.jvm.JarBinarySpec;
import org.gradle.runtime.jvm.JvmLibraryBinarySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BinaryRenderer
extends ReportRenderer<BinarySpec, TextReportBuilder> {
    private final FileResolver fileResolver;

    BinaryRenderer(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public void render(BinarySpec binary, TextReportBuilder builder) {
        StyledTextOutput textOutput = builder.getOutput();
        textOutput.append((CharSequence)StringUtils.capitalize((String)binary.getDisplayName()));
        if (!binary.isBuildable()) {
            textOutput.append((CharSequence)" (not buildable)");
        }
        textOutput.println();
        textOutput.formatln("    build using task: %s", new Object[]{binary.getBuildTask().getPath()});
        if (binary instanceof NativeBinarySpec) {
            SharedLibraryBinarySpec libraryBinary;
            NativeExecutableBinarySpec executableBinary;
            NativeBinarySpec nativeBinary = (NativeBinarySpec)binary;
            textOutput.formatln("    platform: %s", new Object[]{nativeBinary.getTargetPlatform().getName()});
            textOutput.formatln("    build type: %s", new Object[]{nativeBinary.getBuildType().getName()});
            textOutput.formatln("    flavor: %s", new Object[]{nativeBinary.getFlavor().getName()});
            textOutput.formatln("    tool chain: %s", new Object[]{nativeBinary.getToolChain().getDisplayName()});
            if (binary instanceof NativeExecutableBinarySpec) {
                executableBinary = (NativeExecutableBinarySpec)binary;
                textOutput.formatln("    executable file: %s", new Object[]{this.fileResolver.resolveAsRelativePath((Object)executableBinary.getExecutableFile())});
            }
            if (binary instanceof NativeTestSuiteBinarySpec) {
                executableBinary = (NativeTestSuiteBinarySpec)binary;
                textOutput.formatln("    executable file: %s", new Object[]{this.fileResolver.resolveAsRelativePath((Object)executableBinary.getExecutableFile())});
            }
            if (binary instanceof SharedLibraryBinarySpec) {
                libraryBinary = (SharedLibraryBinarySpec)binary;
                textOutput.formatln("    shared library file: %s", new Object[]{this.fileResolver.resolveAsRelativePath((Object)libraryBinary.getSharedLibraryFile())});
            }
            if (binary instanceof StaticLibraryBinarySpec) {
                libraryBinary = (StaticLibraryBinarySpec)binary;
                textOutput.formatln("    static library file: %s", new Object[]{this.fileResolver.resolveAsRelativePath((Object)libraryBinary.getStaticLibraryFile())});
            }
        }
        if (binary instanceof JvmLibraryBinarySpec) {
            JvmLibraryBinarySpec libraryBinary = (JvmLibraryBinarySpec)binary;
            textOutput.formatln("    tool chain: %s", new Object[]{libraryBinary.getToolChain().toString()});
            if (binary instanceof JarBinarySpec) {
                JarBinarySpec jarBinary = (JarBinarySpec)binary;
                textOutput.formatln("    Jar file: %s", new Object[]{this.fileResolver.resolveAsRelativePath((Object)jarBinary.getJarFile())});
            }
            if (binary instanceof ClassDirectoryBinarySpec) {
                ClassDirectoryBinarySpec classDirectoryBinary = (ClassDirectoryBinarySpec)binary;
                textOutput.formatln("    classes dir: %s", new Object[]{this.fileResolver.resolveAsRelativePath((Object)classDirectoryBinary.getClassesDir())});
                textOutput.formatln("    resources dir: %s", new Object[]{this.fileResolver.resolveAsRelativePath((Object)classDirectoryBinary.getResourcesDir())});
            }
        }
    }
}

