/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.runtime.base.library;

import org.gradle.api.DomainObjectSet;
import org.gradle.api.Incubating;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetContainer;
import org.gradle.runtime.base.BinarySpec;
import org.gradle.runtime.base.ComponentSpecIdentifier;
import org.gradle.runtime.base.LibrarySpec;
import org.gradle.runtime.base.ModelInstantiationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class DefaultLibrarySpec
implements LibrarySpec {
    private static ThreadLocal<ComponentInfo> nextComponentInfo = new ThreadLocal();
    private final FunctionalSourceSet mainSourceSet;
    private final LanguageSourceSetContainer sourceSets = new LanguageSourceSetContainer();
    private final ComponentSpecIdentifier identifier;
    private final String typeName;
    private final DomainObjectSet<BinarySpec> binaries = new DefaultDomainObjectSet(BinarySpec.class);

    public static <T extends DefaultLibrarySpec> T create(Class<T> type, ComponentSpecIdentifier identifier, FunctionalSourceSet mainSourceSet, Instantiator instantiator) {
        nextComponentInfo.set(new ComponentInfo(identifier, type.getSimpleName(), mainSourceSet));
        try {
            DefaultLibrarySpec defaultLibrarySpec = (DefaultLibrarySpec)instantiator.newInstance(type, new Object[0]);
            return (T)defaultLibrarySpec;
        }
        catch (ObjectInstantiationException e) {
            throw new ModelInstantiationException(String.format("Could not create library of type %s", type.getSimpleName()), e.getCause());
        }
        finally {
            nextComponentInfo.set(null);
        }
    }

    public DefaultLibrarySpec() {
        this(nextComponentInfo.get());
    }

    private DefaultLibrarySpec(ComponentInfo info) {
        this.identifier = info.componentIdentifier;
        this.typeName = info.typeName;
        this.mainSourceSet = info.sourceSets;
        this.sourceSets.addMainSources(this.mainSourceSet);
    }

    public String getName() {
        return this.identifier.getName();
    }

    @Override
    public String getProjectPath() {
        return this.identifier.getProjectPath();
    }

    @Override
    public String getDisplayName() {
        return String.format("%s '%s'", this.typeName, this.getName());
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public DomainObjectSet<LanguageSourceSet> getSource() {
        return this.sourceSets;
    }

    @Override
    public void source(Object sources) {
        this.sourceSets.source(sources);
    }

    public DomainObjectSet<BinarySpec> getBinaries() {
        return this.binaries;
    }

    public FunctionalSourceSet getMainSource() {
        return this.mainSourceSet;
    }

    private static class ComponentInfo {
        final ComponentSpecIdentifier componentIdentifier;
        final String typeName;
        final FunctionalSourceSet sourceSets;

        private ComponentInfo(ComponentSpecIdentifier componentIdentifier, String typeName, FunctionalSourceSet sourceSets) {
            this.componentIdentifier = componentIdentifier;
            this.typeName = typeName;
            this.sourceSets = sourceSets;
        }
    }
}

