/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.runtime.base.internal.registry;

import java.lang.annotation.IncompleteAnnotationException;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.internal.plugins.PluginApplication;
import org.gradle.api.internal.plugins.PluginApplicationAction;
import org.gradle.api.plugins.PluginAware;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.runtime.base.ComponentModel;
import org.gradle.runtime.base.ComponentSpecContainer;
import org.gradle.runtime.base.InvalidComponentModelException;
import org.gradle.runtime.base.LibrarySpec;
import org.gradle.runtime.base.internal.DefaultComponentSpecIdentifier;
import org.gradle.runtime.base.library.DefaultLibrarySpec;

public class ComponentModelPluginApplicationAction
implements PluginApplicationAction {
    private Instantiator instantiator;

    public ComponentModelPluginApplicationAction(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public void execute(PluginApplication pluginApplication) {
        Class<?>[] declaredClasses = pluginApplication.getPlugin().getClass().getDeclaredClasses();
        if (declaredClasses.length != 0) {
            for (Class<?> declaredClass : declaredClasses) {
                if (!declaredClass.isAnnotationPresent(ComponentModel.class)) continue;
                ComponentModel componentModel = declaredClass.getAnnotation(ComponentModel.class);
                this.validate(componentModel);
                this.registerComponentModel(pluginApplication.getTarget(), componentModel);
            }
        }
    }

    private void validate(ComponentModel componentModel) {
        try {
            Class<? extends LibrarySpec> type = componentModel.type();
            if (!LibrarySpec.class.isAssignableFrom(type)) {
                throw new InvalidComponentModelException(String.format("ComponentModel type '%s' must extend '%s'.", type.getSimpleName(), LibrarySpec.class.getSimpleName()));
            }
        }
        catch (IncompleteAnnotationException ex) {
            throw new InvalidComponentModelException("Parameter 'type' not declared in ComponentModel declaration.", ex);
        }
        try {
            Class<? extends LibrarySpec> implementation = componentModel.implementation();
            if (!componentModel.type().isAssignableFrom(implementation)) {
                throw new InvalidComponentModelException(String.format("ComponentModel implementation '%s' must implement '%s'.", implementation.getSimpleName(), componentModel.type().getSimpleName()));
            }
            if (!DefaultLibrarySpec.class.isAssignableFrom(implementation)) {
                throw new InvalidComponentModelException(String.format("ComponentModel implementation '%s' must extend '%s'.", implementation.getSimpleName(), DefaultLibrarySpec.class.getSimpleName()));
            }
            try {
                implementation.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException nsmException) {
                throw new InvalidComponentModelException(String.format("ComponentModel implementation '%s' must have public default constructor.", implementation.getSimpleName()));
            }
        }
        catch (IncompleteAnnotationException ex) {
            throw new InvalidComponentModelException("Parameter 'implementation' not declared in ComponentModel declaration.", ex);
        }
    }

    private void registerComponentModel(PluginAware target, final ComponentModel componentModel) {
        if (!(target instanceof Project)) {
            throw new InvalidComponentModelException("ComponentModel can only be declared for project plugins.");
        }
        target.getPlugins().apply(ComponentModelBasePlugin.class);
        final Project project = (Project)target;
        final ProjectSourceSet projectSourceSet = (ProjectSourceSet)project.getExtensions().getByType(ProjectSourceSet.class);
        ComponentSpecContainer componentSpecs = (ComponentSpecContainer)project.getExtensions().getByType(ComponentSpecContainer.class);
        try {
            componentSpecs.registerFactory(componentModel.type(), new NamedDomainObjectFactory(){

                public Object create(String name) {
                    FunctionalSourceSet componentSourceSet = (FunctionalSourceSet)projectSourceSet.maybeCreate(name);
                    DefaultComponentSpecIdentifier id = new DefaultComponentSpecIdentifier(project.getPath(), name);
                    return DefaultLibrarySpec.create(componentModel.implementation(), id, componentSourceSet, ComponentModelPluginApplicationAction.this.instantiator);
                }
            });
        }
        catch (GradleException ex) {
            throw new InvalidComponentModelException(String.format("Cannot declare component of type '%s'.", componentModel.type().getSimpleName()), (Exception)((Object)ex));
        }
    }
}

