/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.PolymorphicDomainObjectContainer;
import org.gradle.api.Task;
import org.gradle.api.internal.PolymorphicDomainObjectContainerModelAdapter;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.DefaultLanguageRegistry;
import org.gradle.language.base.internal.LanguageRegistration;
import org.gradle.language.base.internal.LanguageRegistry;
import org.gradle.language.base.internal.plugins.CreateSourceTransformTask;
import org.gradle.language.base.plugins.LanguageBasePlugin;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.model.collection.NamedItemCollectionBuilder;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.runtime.base.BinaryContainer;
import org.gradle.runtime.base.ComponentSpec;
import org.gradle.runtime.base.ComponentSpecContainer;
import org.gradle.runtime.base.internal.BinarySpecInternal;
import org.gradle.runtime.base.internal.ComponentSpecInternal;
import org.gradle.runtime.base.internal.DefaultComponentSpecContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class ComponentModelBasePlugin
implements Plugin<ProjectInternal> {
    private final Instantiator instantiator;
    private final ModelRegistry modelRegistry;

    @Inject
    public ComponentModelBasePlugin(Instantiator instantiator, ModelRegistry modelRegistry) {
        this.instantiator = instantiator;
        this.modelRegistry = modelRegistry;
    }

    public void apply(ProjectInternal project) {
        project.getPlugins().apply(LanguageBasePlugin.class);
        LanguageRegistry languageRegistry = (LanguageRegistry)project.getExtensions().create("languages", DefaultLanguageRegistry.class, new Object[0]);
        ProjectSourceSet sources = (ProjectSourceSet)project.getExtensions().getByType(ProjectSourceSet.class);
        DefaultComponentSpecContainer components = (DefaultComponentSpecContainer)project.getExtensions().create("componentSpecs", DefaultComponentSpecContainer.class, new Object[]{this.instantiator});
        final PolymorphicDomainObjectContainerModelAdapter componentSpecContainerAdapter = new PolymorphicDomainObjectContainerModelAdapter((PolymorphicDomainObjectContainer)components, ModelType.of(ComponentSpecContainer.class), ComponentSpec.class);
        this.modelRegistry.create(new ModelCreator(){

            public ModelPath getPath() {
                return ModelPath.path((String)"componentSpecs");
            }

            public ModelPromise getPromise() {
                return componentSpecContainerAdapter.asPromise();
            }

            public ModelAdapter create(Inputs inputs) {
                return componentSpecContainerAdapter;
            }

            public List<ModelReference<?>> getInputs() {
                return Collections.emptyList();
            }

            public ModelRuleDescriptor getDescriptor() {
                return new SimpleModelRuleDescriptor("Project.<init>.componentSpecs()");
            }
        });
        this.createLanguageSourceSets(sources, components, languageRegistry, project.getFileResolver());
    }

    private void createLanguageSourceSets(final ProjectSourceSet sources, final ComponentSpecContainer components, LanguageRegistry languageRegistry, final FileResolver fileResolver) {
        languageRegistry.all((Action)new Action<LanguageRegistration>(){

            public void execute(LanguageRegistration languageRegistration) {
                ComponentModelBasePlugin.this.registerLanguageSourceSetFactory(languageRegistration, sources, fileResolver);
                ComponentModelBasePlugin.this.createDefaultSourceSetForComponents(languageRegistration, components);
            }
        });
    }

    private void createDefaultSourceSetForComponents(final LanguageRegistration languageRegistration, ComponentSpecContainer components) {
        components.withType(ComponentSpecInternal.class).all((Action)new Action<ComponentSpecInternal>(){

            public void execute(ComponentSpecInternal componentSpecInternal) {
                FunctionalSourceSet functionalSourceSet = componentSpecInternal.getMainSource();
                if (componentSpecInternal.getInputTypes().contains(languageRegistration.getOutputType())) {
                    functionalSourceSet.maybeCreate(languageRegistration.getName(), languageRegistration.getSourceSetType());
                }
            }
        });
    }

    private void registerLanguageSourceSetFactory(final LanguageRegistration languageRegistration, ProjectSourceSet sources, final FileResolver fileResolver) {
        sources.all((Action)new Action<FunctionalSourceSet>(){

            public void execute(final FunctionalSourceSet functionalSourceSet) {
                NamedDomainObjectFactory<LanguageSourceSet> namedDomainObjectFactory = new NamedDomainObjectFactory<LanguageSourceSet>(){

                    public LanguageSourceSet create(String name) {
                        Class sourceSetImplementation = languageRegistration.getSourceSetImplementation();
                        return (LanguageSourceSet)ComponentModelBasePlugin.this.instantiator.newInstance(sourceSetImplementation, new Object[]{name, functionalSourceSet, fileResolver});
                    }
                };
                functionalSourceSet.registerFactory(languageRegistration.getSourceSetType(), (NamedDomainObjectFactory)namedDomainObjectFactory);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @RuleSource
    static class Rules {
        Rules() {
        }

        @Model
        LanguageRegistry languages(ExtensionContainer extensions) {
            return (LanguageRegistry)extensions.getByType(LanguageRegistry.class);
        }

        @Mutate
        void closeComponentsForBinaries(NamedItemCollectionBuilder<Task> tasks, ComponentSpecContainer components) {
        }

        @Finalize
        void createSourceTransformTasks(TaskContainer tasks, BinaryContainer binaries, LanguageRegistry languageRegistry) {
            Iterator i$ = languageRegistry.iterator();
            while (i$.hasNext()) {
                LanguageRegistration language = (LanguageRegistration)i$.next();
                for (BinarySpecInternal binary : binaries.withType(BinarySpecInternal.class)) {
                    CreateSourceTransformTask createRule = new CreateSourceTransformTask(language);
                    createRule.createCompileTasksForBinary(tasks, binary);
                }
            }
        }

        @Finalize
        void applyDefaultSourceConventions(ProjectSourceSet sources) {
            Iterator i$ = sources.iterator();
            while (i$.hasNext()) {
                FunctionalSourceSet functionalSourceSet = (FunctionalSourceSet)i$.next();
                Iterator i$2 = functionalSourceSet.iterator();
                while (i$2.hasNext()) {
                    LanguageSourceSet languageSourceSet = (LanguageSourceSet)i$2.next();
                    if (!languageSourceSet.getSource().getSrcDirs().isEmpty()) continue;
                    languageSourceSet.getSource().srcDir((Object)String.format("src/%s/%s", functionalSourceSet.getName(), languageSourceSet.getName()));
                }
            }
        }

        @Mutate
        void closeSourcesForBinaries(BinaryContainer binaries, ProjectSourceSet sources) {
        }
    }
}

