/*
vox.h - sentences vox private header
Copyright (C) 2010 Uncle Mike

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/

#ifndef VOX_H
#define VOX_H

#define CVOXWORDMAX			32
#define CVOXSENTENCEMAX		24
#define CVOXZEROSCANMAX		255	// scan up to this many samples for next zero crossing
#define MAX_SENTENCES		2048
#define SENTENCE_INDEX		-99999	// unique sentence index

typedef struct voxword_s
{
	int	volume;		// increase percent, ie: 125 = 125% increase
	int	pitch;		// pitch shift up percent
	int	start;		// offset start of wave percent
	int	end;		// offset end of wave percent
	int	cbtrim;		// end of wave after being trimmed to 'end'
	int	fKeepCached;	// 1 if this word was already in cache before sentence referenced it
	int	samplefrac;	// if pitch shifting, this is position into wav * 256
	int	timecompress;	// % of wave to skip during playback (causes no pitch shift)
	sfx_t	*sfx;		// name and cache pointer
} voxword_t;


typedef struct
{
	char		*pName;
	float		length;
} sentence_t;

extern sentence_t		g_Sentences[MAX_SENTENCES];

#endif