#include "main.h"

enginefuncs_t g_engfuncs;
globalvars_t *gpGlobals;

#if _MSC_VER > 1000
#pragma comment(linker, "/EXPORT:GiveFnptrsToDll=_GiveFnptrsToDll@8,@1")
#pragma comment(linker, "/SECTION:.data,RW")
#endif

C_DLLEXPORT void WINAPI GiveFnptrsToDll(enginefuncs_t* pengfuncsFromEngine, globalvars_t *pGlobals)
{
   memcpy(&g_engfuncs, pengfuncsFromEngine, sizeof(enginefuncs_t));
   gpGlobals = pGlobals;
}

static META_FUNCTIONS gMetaFunctionTable = {
   GetEntityAPI, NULL, NULL, NULL, NULL, NULL, GetEngineFunctions, NULL,
};

plugin_info_t Plugin_info = {
	META_INTERFACE_VERSION,
	"Enable CSBot",
	__DATE__,
	__DATE__,
	"Whistler <whistler_wmz@users.sf.net>",
	"http://yapb.bots-united.com",
	"BOTENAB",
	PT_ANYTIME,
	PT_ANYPAUSE,
};

meta_globals_t *gpMetaGlobals;
gamedll_funcs_t *gpGamedllFuncs;
mutil_funcs_t *gpMetaUtilFuncs;

C_DLLEXPORT int Meta_Query(char *ifvers, plugin_info_t **pPlugInfo,
    mutil_funcs_t *pMetaUtilFuncs) {
   *pPlugInfo = &Plugin_info;
   gpMetaUtilFuncs = pMetaUtilFuncs;
   return TRUE;
}

C_DLLEXPORT int Meta_Attach(PLUG_LOADTIME now,
    META_FUNCTIONS *pFunctionTable, meta_globals_t *pMGlobals, 
    gamedll_funcs_t *pGamedllFuncs) {
   gpMetaGlobals = pMGlobals;

   memcpy(pFunctionTable, &gMetaFunctionTable, sizeof(META_FUNCTIONS));
   gpGamedllFuncs = pGamedllFuncs;
   return TRUE;
}

C_DLLEXPORT int Meta_Detach(PLUG_LOADTIME, PL_UNLOAD_REASON) {
   return TRUE;
}

