//
// engine_api.cpp
//
// Implementation of Half-Life engine functions
//

#include "main.h"
#ifdef _WIN32
#include <io.h>
#else
#include <unistd.h>
#endif

int pfnPrecacheModel(char* s) {
   if (strncmp(s, "models/hostage", 14) == 0 ||
      strstr(s, "spetsnaz") != NULL ||
      strstr(s, "militia") != NULL) {
      RETURN_META_VALUE(MRES_SUPERCEDE, g_engfuncs.pfnPrecacheModel("models/hostage.mdl"));
   }
   RETURN_META_VALUE(MRES_IGNORED, 0);
}

int pfnPrecacheSound(char* s) {
   if (strncmp(s, "hostage/", 8) == 0) {
      static int i = 0;
      switch (i++ % 5) {
      case 0:
         RETURN_META_VALUE(MRES_SUPERCEDE, (*g_engfuncs.pfnPrecacheSound)("hostage/hos1.wav"));
      case 1:
         RETURN_META_VALUE(MRES_SUPERCEDE, (*g_engfuncs.pfnPrecacheSound)("hostage/hos2.wav"));
      case 2:
         RETURN_META_VALUE(MRES_SUPERCEDE, (*g_engfuncs.pfnPrecacheSound)("hostage/hos3.wav"));
      case 3:
         RETURN_META_VALUE(MRES_SUPERCEDE, (*g_engfuncs.pfnPrecacheSound)("hostage/hos4.wav"));
      case 4:
      default:
         RETURN_META_VALUE(MRES_SUPERCEDE, (*g_engfuncs.pfnPrecacheSound)("hostage/hos5.wav"));
      }
   }
   RETURN_META_VALUE(MRES_IGNORED, 0);
}

void pfnSetModel(edict_t *e, const char *m) {
   if (strncmp(m, "models/hostage", 14) == 0) {
      g_engfuncs.pfnSetModel(e, "models/hostage.mdl");
      RETURN_META(MRES_SUPERCEDE);
   }
   RETURN_META(MRES_IGNORED);
}

int pfnModelIndex(const char *m) {
   if (strncmp(m, "models/hostage", 14) == 0) {
      RETURN_META_VALUE(MRES_SUPERCEDE, g_engfuncs.pfnModelIndex("models/hostage.mdl"));
   }
   RETURN_META_VALUE(MRES_IGNORED, 0);
}

void pfnEmitSound(edict_t *entity, int channel, const char *sample, float volume, float attenuation, int fFlags, int pitch) {
   if (strncmp(sample, "hostage/", 8) == 0) {
      if (strncmp(sample, "hostage/huse/", 13) == 0) {
         switch (rand() % 5) {
         case 0:
            (*g_engfuncs.pfnEmitSound)(entity, channel, "hostage/hos1.wav", volume, attenuation, fFlags, pitch);
            break;
         case 1:
            (*g_engfuncs.pfnEmitSound)(entity, channel, "hostage/hos2.wav", volume, attenuation, fFlags, pitch);
            break;
         case 2:
            (*g_engfuncs.pfnEmitSound)(entity, channel, "hostage/hos3.wav", volume, attenuation, fFlags, pitch);
            break;
         case 3:
            (*g_engfuncs.pfnEmitSound)(entity, channel, "hostage/hos4.wav", volume, attenuation, fFlags, pitch);
            break;
         case 4:
         default:
            (*g_engfuncs.pfnEmitSound)(entity, channel, "hostage/hos5.wav", volume, attenuation, fFlags, pitch);
            break;
         }
      }
      RETURN_META(MRES_SUPERCEDE);
   }
   RETURN_META(MRES_IGNORED);
}


byte *pfnLoadFileForMe(char *filename, int *pLength) {
   int length = strlen(filename);
   if (strcmp(&filename[length - 4], ".nav") == 0) {
      int i = length;
      while (i > 0 && filename[i] != '/' && filename[i] != '\\')
         i--;
      if (i > 0)
         i++;
#ifndef __linux__
      if (access(va("czero\\maps\\%s", &filename[i]), 0) != -1) {
#else
      if (access(va("czero/maps/%s", &filename[i]), 0) != -1) {
#endif
         RETURN_META_VALUE(MRES_SUPERCEDE, (*g_engfuncs.pfnLoadFileForMe)(va("../czero/maps/%s", &filename[i]), pLength));
      }
   }
   RETURN_META_VALUE(MRES_IGNORED, 0);
}

void pfnGetGameDir(char *szGetGameDir) {
   strcpy(szGetGameDir, "czero");
   RETURN_META(MRES_SUPERCEDE);
}

void pfnSetClientKeyValue(int clientIndex, char *infobuffer, char *key, char *value) {
   if (strcmp(key, "model") == 0) {
      if (strcmp(value, "spetsnaz") == 0) {
         char *models[] = {"urban", "gsg9", "sas", "gign"};
         g_engfuncs.pfnSetClientKeyValue(clientIndex, infobuffer, key, models[rand() % 4]);
         RETURN_META(MRES_SUPERCEDE);
      } else if (strcmp(value, "militia") == 0) {
         char *models[] = {"terror", "leet", "arctic", "guerilla"};
         g_engfuncs.pfnSetClientKeyValue(clientIndex, infobuffer, key, models[rand() % 4]);
         RETURN_META(MRES_SUPERCEDE);
      }
   }
   RETURN_META(MRES_IGNORED);
}

C_DLLEXPORT int GetEngineFunctions(enginefuncs_t *pengfuncsFromEngine, 
                                   int *interfaceVersion) 
{
   pengfuncsFromEngine->pfnPrecacheModel = pfnPrecacheModel;
   pengfuncsFromEngine->pfnPrecacheSound = pfnPrecacheSound;
   pengfuncsFromEngine->pfnSetModel = pfnSetModel;
   pengfuncsFromEngine->pfnModelIndex = pfnModelIndex;
   pengfuncsFromEngine->pfnEmitSound = pfnEmitSound;
   pengfuncsFromEngine->pfnLoadFileForMe = pfnLoadFileForMe;
   pengfuncsFromEngine->pfnGetGameDir = pfnGetGameDir;
   pengfuncsFromEngine->pfnSetClientKeyValue = pfnSetClientKeyValue;

   return TRUE;
}
