/*	AMX Mod X script.

	Speedometer by Lev (based on plugin by AciD)

	Chat command:
		/speed	- toggle display of speed.

	CVARs:
		sm_show <0|1> (default=0)		// On/Off for new connecting players by default. They can use chat command /speed to toggle.
		sm_type <1|2> (default=1)		// Type of coloring (by average acceleration or average speed).
		sm_samples <num> (default=10)	// Number of samples for calculating average speed and acceleration.

	Credits:
		AciD for his speedometer plugin.
		Freejam for betatesting and good ideas.

	ChangeLog:
		v1.0 [2009.09.11]
			! Fix: making CVARs normally working.
			! Fix: making hud text more consistent (not blinking as before).
			! Change: interval of measurement now set to 0.05 sec.
			! Change: by default show of speed is off.
			! Change: Dymanic colors.
			! Change: Added more info on informer.
		v1.1 [2009.09.11]
			! Change: Added info about acceleration.
			! Change: Two types of calculating colors.
		v1.2 [2009.09.25]
			! Change: Output less info for less bandwidth consume.
		v1.3 [2010.02.07]
			! Change: Added mod dependent info message.
			! Change: Removed sm_freq CVAR.
			! Change: code optimizations.
		v1.4 [2010.04.24]
			! Change: Added real horisontal speed calculation based on origin changes.

	TODO:
		Add custom type of display.
		Add motd with description how to use custom type.

*/

#pragma semicolon 1
#pragma ctrlchar '\'

#define PLUGIN "Speedometer"
#define VERSION "1.4"
#define AUTHOR "Lev"

#define MAX_PLAYERS	32
#define MAX_SAMPLES	10

#include <amxmodx>
#include <fakemeta>

new TaskEnt;
new messageType = 0;
new Float:lastTime;

// Players' data
new showSpeed[MAX_PLAYERS + 1];
new Float:lastOrigin[MAX_PLAYERS + 1][3];
new Float:lastSpeed[MAX_PLAYERS + 1];
new Float:avgSpeed[MAX_PLAYERS + 1];
new currentSample[MAX_PLAYERS + 1];
new Float:accelSamples[MAX_PLAYERS + 1][MAX_SAMPLES];
new Float:realSpeedHSamples[MAX_PLAYERS + 1][MAX_SAMPLES];
new Float:mult[MAX_PLAYERS + 1];

// CVARs
new pcvar_sm_show;
new pcvar_sm_type;
new pcvar_sm_samples;

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR);
	register_cvar("sm_version", VERSION, FCVAR_SPONLY | FCVAR_SERVER | FCVAR_UNLOGGED);

	pcvar_sm_show = register_cvar("sm_show", "0");
	pcvar_sm_type = register_cvar("sm_type", "1");
	pcvar_sm_samples = register_cvar("sm_samples", "10");

	register_clcmd("say /speed", "ToogleSpeed");
	
	register_forward(FM_Think, "fw_FM_Think");
	TaskEnt = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"));
	set_pev(TaskEnt, pev_classname, "speedometer_think");
	set_pev(TaskEnt, pev_nextthink, get_gametime() + 1.01);

	new modname[32];
	get_modname(modname, charsmax(modname));
	if (equal(modname, "ag"))
		messageType = 1;
}

public ToogleSpeed(id)
{
	showSpeed[id]++;
	if (showSpeed[id] > 4)
	{
		showSpeed[id] = 0;
		set_hudmessage(255, 255, 255, -1.0, 0.85, 0, 0.0, 3.0, 0.0, 0.0, 4);
		show_hudmessage(id, "");
	}
	return PLUGIN_CONTINUE;
}

public client_connect(id)
{
	showSpeed[id] = get_pcvar_num(pcvar_sm_show);
	lastSpeed[id] = 0.0;
	currentSample[id] = 0;
	mult[id] = 3.0;
	set_task(5.0, "showInfo", id);
}

public showInfo(id)
{
	switch(messageType)
	{
		case 0:
			client_print(id, print_chat, "[Speedometer] Type: \"/speed\" in chat to toggle show of your speed.");
		case 1:
			client_print(id, print_chat, "^8[^1Speedometer^8]^0 ^3Type: ^8\"^2/speed^8\" ^3in chat to toggle show of your speed.^3");
	}
}

public fw_FM_Think(ent)
{
	if (ent == TaskEnt) 
	{
		SpeedTask();
		set_pev(ent, pev_nextthink, get_gametime() + 0.05);
	}
}

SpeedTask()
{
	static target;
	static Float:currentTime;
	static Float:origin[3], Float:velocity[3];
	static Float:speed, Float:speedh, Float:realSpeedH, Float:speedv, Float:diff, Float:accel, Float:avgAccel, Float:avgRealSpeedH;
	static r, g, b, colorDiff;
	static sm_type;
	static sm_samples;

	currentTime = get_gametime();
	sm_type = get_pcvar_num(pcvar_sm_type);
	sm_samples = get_pcvar_num(pcvar_sm_samples);

	static players[MAX_PLAYERS], num, id, i, j;
	get_players(players, num);
	for (i = 0; i < num; i++)
	{
		id = players[i];
		if (!showSpeed[id] || is_user_bot(id))
			continue;

		target = pev(id, pev_iuser1) == 4 ? pev(id, pev_iuser2) : id;
		pev(target, pev_origin, origin);
		pev(target, pev_velocity, velocity);

		// Calculate different speeds
		speed = vector_length(velocity);
		speedh = floatsqroot(floatpower(velocity[0], 2.0) + floatpower(velocity[1], 2.0));
		speedv = floatabs(velocity[2]);
		realSpeedH = floatsqroot(floatpower(origin[0] - lastOrigin[id][0], 2.0) + floatpower(origin[1] - lastOrigin[id][1], 2.0)) / (currentTime - lastTime);

		// Calculate acceleration
		accel = (speedh - lastSpeed[id]) / (currentTime - lastTime);

		// Store current horisontal speed and acceleration
		lastSpeed[id] = speedh;
		realSpeedHSamples[id][currentSample[id]] = realSpeedH;
		accelSamples[id][currentSample[id]] = accel;
		currentSample[id]++;
		if (currentSample[id] >= MAX_SAMPLES)
			currentSample[id] = 0;
		lastOrigin[id][0] = origin[0];
		lastOrigin[id][1] = origin[1];
		lastOrigin[id][2] = origin[2];

		// Calculate average real horisontal speed, average horisontal speed and average acceleration
		avgSpeed[id] = (avgSpeed[id] * (sm_samples - 1) + speedh) / sm_samples;
		avgRealSpeedH = 0.0;
		avgAccel = 0.0;
		for (j = 0; j < MAX_SAMPLES; j++)
		{
			avgRealSpeedH += realSpeedHSamples[id][j];
			avgAccel += accelSamples[id][j];
		}
		avgRealSpeedH /= MAX_SAMPLES;
		avgAccel /= MAX_SAMPLES;

		// Calculate difference of selected parameter
		switch(sm_type)
		{
			case 1:
				diff = floatclamp((avgAccel) * mult[id], -255.0, 255.0);
			case 2:
				diff = floatclamp((speedh - avgSpeed[id]) * mult[id], -255.0, 255.0);
		}

		// Calculate multiplier
		if (floatabs(diff) < 50) mult[id] += 0.8;
		if (floatabs(diff) < 150) mult[id] += 0.2;
		if (floatabs(diff) > 210) mult[id] -= 0.2;
		if (floatabs(diff) > 250) mult[id] -= 0.8;
		if (mult[id] < 1.0) mult[id] = 1.0;
		if (mult[id] > 20.0) mult[id] = 20.0;

		// Calculate color
		colorDiff = floatround(diff, floatround_tozero);
		if (colorDiff >= 0)
		{
			r = 255 - colorDiff;
			g = 255;
			b = 255 - colorDiff;
		}
		else
		{
			r = 255;
			g = 255 + colorDiff;
			b = 255 + colorDiff;
		}

		// Show hud message
		set_hudmessage(r, g, b, -1.0, 0.85, 0, 0.0, 30.0, 0.0, 0.0, 4);
		switch(showSpeed[id])
		{
			case 1:
				show_hudmessage(id, "Horisontal speed: %03.0f\nAvg real horisontal speed: %03.0f", speedh, avgRealSpeedH);
			case 2:
				show_hudmessage(id, "Horisontal speed: %03.0f\nVertical speed: %03.0f", speedh, speedv);
			case 3:
				show_hudmessage(id, "Horisontal speed: %03.0f\nVertical speed: %03.0f\nSpeed: %03.0f", speedh, speedv, speed);
			case 4:
				show_hudmessage(id, "Acceleration: %03.1f, Multiplier: %02.1f\nHorisontal speed: %03.0f\nSpeed: %03.0f", avgAccel, mult[id], speedh, speed);
			case 5:
				show_hudmessage(id, "Acceleration: %03.1f\n Difference: %03.1f, Multiplier: %02.1f\nHorisontal speed: %03.0f, Vertical speed: %03.0f\nSpeed: %03.0f", avgAccel, diff, mult[id], speedh, speedv, speed);
			default:
				show_hudmessage(id, "Horisontal speed: %03.0f", speedh);
		}
	}

	lastTime = currentTime;
}
