/*	AMX Mod X script.

	Satchels Remover plugin by Lev.

	URL: 

	Info:
		This plugin removes satchels on player death or disconnect.

	Change Log:
		v1.0 [2010.04.15]
			Initial release.

*/

#pragma semicolon 1
#pragma ctrlchar '\'

#include <amxmodx>
#include <amxmisc>
#include <fakemeta>

#define AUTHOR "Lev"
#define PLUGIN "Satchels Remover"
#define PLUGIN_TAG "SC"
#define VERSION "1.0"
#define VERSION_CVAR "satchels_remover_version"

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR);
	register_cvar(VERSION_CVAR, VERSION, FCVAR_SPONLY | FCVAR_SERVER | FCVAR_UNLOGGED);

	register_clcmd("sr_remove", "CmdRemove", ADMIN_BAN, "- removes satchels for given player");
	register_clcmd("spectate", "OnSpectate");
	register_event("DeathMsg", "OnDeath", "a");
}

public client_disconnect(id)
{
	RemoveSatchels(id);
	return PLUGIN_CONTINUE;
}

public OnSpectate(id)
{
	RemoveSatchels(id);
	return PLUGIN_CONTINUE;
}

public OnDeath()
{
	static victimId;
	victimId = read_data(2);
	RemoveSatchels(victimId);
	return PLUGIN_CONTINUE;
}

public CmdRemove(id, level, cid)
{
	if (!cmd_access(id, level, cid, 2))
		return PLUGIN_HANDLED;

	new param[10], inputId;
	read_argv(1, param, charsmax(param));
	inputId = LocatePlayer(id, param, false, false);

	RemoveSatchels(inputId);
	return PLUGIN_HANDLED;
}

/// Removes satchels for given player.
RemoveSatchels(id)
{
	static ent;
	while ((ent = engfunc(EngFunc_FindEntityByString, ent, "classname", "monster_satchel")))
	{
		if (pev(ent, pev_owner) != id)
			continue;

		engfunc(EngFunc_RemoveEntity, ent);
	}
}

/// Find player index based on Steam ID or partial player name or user IP or used ID.
/// If player not found or multiple players found returns -1.
/// If player has immunity and "checkImmunity" parameter is true then function returns -1.
/// If player is bot then function returns -1.
/// Returns player index on success and -1 othewise.
/// Remark: this function outputs information in console on unsuccess.
stock LocatePlayer(id, identStr[], bool:checkImmunity, bool:checkBot)
{
	new player, player1[4], player2[4];
	// Find based on steam ID
	player1[0] = find_player("c", identStr);
	player2[0] = find_player("cj", identStr);

	// Find based on a partial non-case sensitive name
	player1[1] = find_player("bl", identStr);
	player2[1] = find_player("blj", identStr);

	// Find based on IP address
	player1[2] = find_player("d", identStr);
	player2[2] = find_player("dj", identStr);

	// Find based on user ID
	if (identStr[0]=='#' && identStr[1])
		player1[3] = player2[3] = find_player("k", str_to_num(identStr[1]));

	// Check if multiple players found
	for (new i = 0; i < 4; i++)
	{
		if (player1[i] != 0)
		{
			if ((player != 0 && player != player1[i]) || player1[i] != player2[i])
			{
				console_print(id, "[%s] %L.", PLUGIN_TAG, id, "MORE_CL_MATCHT", identStr);
				return -1;
			}
			player = player1[i];
		}
	}

	// Check if player not found
	if (!player)
	{
		console_print(id, "[%s] %L.", PLUGIN_TAG, id, "CL_NOT_FOUND");
		return -1;
	}

	// Check for immunity
	if (checkImmunity && get_user_flags(player) & ADMIN_IMMUNITY)
	{
		new name[32];
		get_user_name(player, name, charsmax(name));
		console_print(id, "[%s] %L.", PLUGIN_TAG, id, "CLIENT_IMM", name);
		return -1;
	}

	// Check for a bot
	if (checkBot && is_user_bot(player))
	{
		new name[32];
		get_user_name(player, name, charsmax(name));
		console_print(id, "[%s] %L.", PLUGIN_TAG, id, "CANT_PERF_BOT", name);
		return -1;
	}

	return player;
}
