/*	AMX Mod X script.

	HL Admin Spectate plugin by Lev.

	Info:
		This plugin allows only players with specified flags to use spectate.
		Designed for use in HLDM.

	CVARs:
		as_allow <flags from a to z> (default=c)	// Player that have any of specified flags is allowed to enter spectate.

	Installation:
		put hl_admin_spectate.amxx to plugins folder;
		add hl_admin_spectate.amxx to config\plugins.ini file (it is preferred to put it before any custom plugin);

	Change Log:
		v1.0 [2010.04.30]
			Initial release.

*/

#pragma semicolon 1
#pragma ctrlchar '\'

#include <amxmodx>

#define AUTHOR "Lev"
#define PLUGIN "HL Admin Spectate"
#define VERSION "1.0"
#define VERSION_CVAR "hl_admin_spectate_version"

new pcvar_as_allow;

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR);
	register_cvar(VERSION_CVAR, VERSION, FCVAR_SPONLY | FCVAR_SERVER | FCVAR_UNLOGGED);

	pcvar_as_allow = register_cvar("as_allow", "c");	// Flags that allow player to use spectate.
	register_clcmd("spectate", "OnSpectate");
}

public OnSpectate(id)
{
	new flagsStr[33];
	get_pcvar_string(pcvar_as_allow, flagsStr, charsmax(flagsStr));
	new flags = read_flags_fixed(flagsStr);
	if (get_user_flags(id) & flags == 0)
		return PLUGIN_HANDLED;
	return PLUGIN_CONTINUE;
} 

/// Converts string of flags into int.
/// Only chars from 'a' to 'z' are converted, others are skipped.
stock read_flags_fixed(const flags[])
{
	new result, i = 0;
	while (flags[i] != 0)
	{
		if (flags[i] >= 'a' && flags[i] <= 'z')
			result |= 1 << (flags[i] - 'a');
		i++;	
	}
	return result;
}
