/* AMXX Mod script.
*
* (c) Copyright 2014, AGHL.RU Dev Team
* This file is provided as is (no warranties). 
*/

#pragma semicolon 1
#pragma ctrlchar '\'

#include <amxmodx>
#include <cstrike>
#include <fakemeta>

#define PLUGIN "CSFix"
#define VERSION "1.1"
#define AUTHOR "Lev"

#define OFFSET_MENU	205


public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR);
	register_clcmd("joinclass", "clcmd_joinclass");
	register_clcmd("menuselect", "clcmd_menuselect");
}

public clcmd_joinclass(id)
{
	new CsTeams:teamId = cs_get_user_team(id);
	if (teamId != CS_TEAM_T && teamId != CS_TEAM_CT)
		return PLUGIN_HANDLED;
	return PLUGIN_CONTINUE;
}

public clcmd_menuselect(id)
{
	new iMenu = get_pdata_int(id, OFFSET_MENU);
	if (iMenu == 3)
	{
		new CsTeams:teamId = cs_get_user_team(id);
		if (teamId != CS_TEAM_T && teamId != CS_TEAM_CT)
		{
			set_pdata_int(id, OFFSET_MENU, 0);
			return PLUGIN_HANDLED;
		}
	}
	return PLUGIN_CONTINUE;
}
